#!/sbin/sh
#
# @(#) $Revision: 1.2 $
#

#
# This is the HP-UX 11.00 initialisation script for the "random" DLKM
#

# Allowed exit values:
#	0 = success; causes "OK" to show up in checklist.
#	1 = failure; causes "FAIL" to show up in checklist.
#	2 = skip; causes "N/A" to show up in the checklist.
#           Use this value if execution of this script is overridden
#	    by the use of a control variable, or if this script is not
#	    appropriate to execute for some other reason.
#       3 = reboot; causes the system to be rebooted after execution.
#	4 = background; causes "BG" to show up in the checklist.
#           Use this value if this script starts a process in background mode.

# Input and output:
#	stdin is redirected from /dev/null
#
#	stdout and stderr are redirected to the /etc/rc.log file
#	during checklist mode, or to the console in raw mode.

PATH=/usr/sbin:/usr/bin:/sbin
export PATH

# NOTE: If your script executes in run state 0 or state 1, then /usr might
#	not be available.  Do not attempt to access commands or files in
#	/usr unless your script executes in run state 2 or greater.  Other
#	file systems typically not mounted until run state 2 include /var
#	and /opt.

rval=0

# Check the exit value of a command run by this script.  If non-zero, the
# exit code is echoed to the log file and the return value of this script
# is set to indicate failure.

set_return() {
	x=$?
	if [ $x -ne 0 ]; then
		echo "EXIT CODE: $x"
		rval=1	# script FAILed
	fi
}

#
# The main program
#

case $1 in
'start_msg')
	# Emit a _short_ message relating to running this script with
	# the "start" argument; this message appears as part of the checklist.
	echo "Loading the /dev/random DLKM"
	;;

'stop_msg')
	# Emit a _short_ message relating to running this script with
	# the "stop" argument; this message appears as part of the checklist.
	echo "Unloading the /dev/random DLKM"
	;;

'start')
	# source the system configuration variables
	if [ -f /etc/rc.config ] ; then
		. /etc/rc.config
	else
		echo "ERROR: /etc/rc.config defaults file MISSING"
	fi

	# Check to see if this script is allowed to run...
	if [ "$RANDOM_DLKM" != 1 ]; then
		rval=2
	else
		kmtune -s random_debug=$RANDOM_DEBUG
		kmtune -s random_io_threshold=$RANDOM_IO_THRESHOLD
		config -M random -u
		kmadmin -L random

		major=$(lsdev | grep -i random | awk '{print $1}')

		rm -f /dev/random /dev/urandom 2>/dev/null
		mknod /dev/urandom c $major 1
		mknod /dev/random c $major 2
		chmod 444 /dev/random /dev/urandom

		if [ "$RANDOM_DEV_PANIC" -eq 1 ]; then
			rm -f /dev/panic 2>/dev/null
			mknod /dev/panic c $major 3
			chmod 600 /dev/panic
		fi
	fi
	;;

'stop')
	kmadmin -U random
	rm -f /dev/random /dev/urandom /dev/panic 2>/dev/null
	;;

'restart')
	$0 stop
	$0 start
	;;

*)
	echo "usage: $0 {start|stop|start_msg|stop_msg}"
	rval=1
	;;
esac

exit $rval
